<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Madd_Magazine
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-D78MKY4EFT"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-D78MKY4EFT');
</script>

	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site-wrapper">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'madd-magazine' ); ?></a>
	<header id="masthead" class="header">
		
			<div class="container">
				
				
			
		</div>
	</header>
	<div class="main-page">
		<div class="top-ads-wrap">
			<div class="container">
				<div class="row">
					<div class="col-md-9 col-md-push-3">
						<div class="top-ads-block">
							<?php if(!function_exists('dynamic_sidebar') || !dynamic_sidebar('ads-widget1')) ?>
						</div>
					</div>
					<div class="col-md-3 col-md-pull-9">
						<div class="site-branding header-site-branding">
							<div class="logo-wrap">
								<?php the_custom_logo(); ?>
							</div>
							<?php
								if ( is_front_page() && is_home() ) : ?>
									<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
								<?php else : ?>
									<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
								<?php
								endif;

								$description = get_bloginfo( 'description', 'display' );
								if ( esc_attr($description) || is_customize_preview() ) : ?>
									<p class="site-description"><?php echo esc_html($description); /* WPCS: xss ok. */ ?></p>
								<?php
								endif; ?>
						</div><!-- .site-branding -->
					</div>
				</div>
			</div>
		</div>
		<div id="content" class="site-content">
